-- Columns

CREATE TABLE [dbo].[ICON_ASSOCIATION]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[BED_UID] [uniqueidentifier] NULL,
[PATIENT_UID] [uniqueidentifier] NULL,
[ICON_FLAG_ID] [int] NULL,
[ICON_FLAG_FACILITY_ID] [int] NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_ICON_ASSOCIATION__ssis_timestamp] DEFAULT (getdate())
)
GO
-- Triggers

CREATE trigger [dbo].[ICON_ASSOCIATION_tgg_ssis_delete] on [dbo].[ICON_ASSOCIATION] after delete as begin  delete [dbo].[ICON_ASSOCIATION_ssisdel] from [deleted] _xyz where [dbo].[ICON_ASSOCIATION_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ICON_ASSOCIATION_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end


GO


CREATE trigger [dbo].[ICON_ASSOCIATION_tgg_ssis_insert] on [dbo].[ICON_ASSOCIATION] after insert as begin delete [dbo].[ICON_ASSOCIATION_ssisdel]  from [inserted] _xyz where [dbo].[ICON_ASSOCIATION_ssisdel].[ID]=[_xyz].[ID] end


GO




CREATE TRIGGER [dbo].[utg_ICON_ASSOCIATION_AfterDelete] 
   ON  [dbo].[ICON_ASSOCIATION]
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')    
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_ASSOCIATION_H]
			(ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM deleted;

END

SET ANSI_NULLS ON


GO


CREATE TRIGGER [dbo].[utg_ICON_ASSOCIATION_AfterInsert] 
   ON  [dbo].[ICON_ASSOCIATION] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_ASSOCIATION_H]
			(ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;


END

SET ANSI_NULLS ON


GO


CREATE TRIGGER [dbo].[utg_ICON_ASSOCIATION_AfterUpdate] 
   ON  [dbo].[ICON_ASSOCIATION] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_ASSOCIATION_H]
			(ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;

END

SET ANSI_NULLS ON


GO


CREATE TRIGGER [dbo].[utg_ICON_ASSOCIATION_InsteadOfInsert] 
   ON  [dbo].[ICON_ASSOCIATION]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[ICON_ASSOCIATION]
			(BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT  BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;

	ELSE
		INSERT INTO [dbo].[ICON_ASSOCIATION]
			(BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, _ssis_timestamp)
		SELECT  BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID, _ssis_timestamp
		FROM inserted;

END

SET ANSI_NULLS ON


GO


CREATE TRIGGER [dbo].[utg_ICON_ASSOCIATION_InsteadOfUpdate] 
   ON  [dbo].[ICON_ASSOCIATION] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[ICON_ASSOCIATION]
		SET BED_UID = inserted.BED_UID, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ICON_FLAG_ID = inserted.ICON_FLAG_ID, 
			ICON_FLAG_FACILITY_ID = inserted.ICON_FLAG_FACILITY_ID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[ICON_ASSOCIATION]
			INNER JOIN inserted ON inserted.ID = [dbo].[ICON_ASSOCIATION].ID;
	 ELSE
	    UPDATE [dbo].[ICON_ASSOCIATION]
		SET BED_UID = inserted.BED_UID, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ICON_FLAG_ID = inserted.ICON_FLAG_ID, 
			ICON_FLAG_FACILITY_ID = inserted.ICON_FLAG_FACILITY_ID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[ICON_ASSOCIATION]
			INNER JOIN inserted ON inserted.ID = [dbo].[ICON_ASSOCIATION].ID;

END
GO

-- Constraints
ALTER TABLE [dbo].[ICON_ASSOCIATION] ADD CONSTRAINT [PK_ICON_ASSOCIATION] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[ICON_ASSOCIATION] ADD CONSTRAINT [FK_ICON_ASSOCIATION_ICON_FLAG_FACILITY] FOREIGN KEY ([ICON_FLAG_FACILITY_ID]) REFERENCES [dbo].[ICON_FLAG_FACILITY] ([ID])
GO
ALTER TABLE [dbo].[ICON_ASSOCIATION] ADD CONSTRAINT [FK_ICON_ASSOCIATION_ICON_FLAG] FOREIGN KEY ([ICON_FLAG_ID]) REFERENCES [dbo].[ICON_FLAG] ([ID])
GO


--Indexes
CREATE NONCLUSTERED INDEX [IDX_PATIENT_ICON_FLAG] ON [dbo].[ICON_ASSOCIATION] 
(
	[PATIENT_UID] ASC,
	[ICON_FLAG_ID] ASC,
	[ICON_FLAG_FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_PATIENT_ICON_FLAG_FACILITY] ON [dbo].[ICON_ASSOCIATION] 
(
	[PATIENT_UID] ASC,
	[ICON_FLAG_FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_UID_IFF_ID] ON [dbo].[ICON_ASSOCIATION] 
(
	[BED_UID] ASC,
	[ICON_FLAG_FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_IF_ID_IFF_ID] ON [dbo].[ICON_ASSOCIATION] 
(
	[BED_UID] ASC,
	[ICON_FLAG_ID] ASC,
	[ICON_FLAG_FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_IFF_ID] ON [dbo].[ICON_ASSOCIATION] 
(
	[ICON_FLAG_FACILITY_ID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[ICON_ASSOCIATION] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'BED_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Icon id from the icon definition table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'ICON_FLAG_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Icon id from the icon facility table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'ICON_FLAG_FACILITY_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that associates icons with their corresponding bed or patient id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_ASSOCIATION'
GO